//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 16 materials and 73 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.3a For Windows Copyright (c) 1993-2001 Lutz + Kretzschmar
//

//  Date : 02/03/2003    (03.02.2003)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.3a For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 on
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
}

background { color <1.000,1.000,1.000> }

camera {  //  Camera Camera01
  location  <     -8.800,     -12.000,       5.700>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38192,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      40.800
  look_at   <      4.000,       4.700,       5.000>
}

//
// *******  L I G H T S *******
//

#declare Light007 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  10.0
  fade_power 1.0
  media_attenuation on
  translate  0.5*z
}

#declare Light006 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  10.0
  fade_power 1.0
  media_attenuation on
  translate  0.5*z
}


//
// ********  MATERIALS  *******
//

#include "old technology.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Wall = object {
  box { // Wall
    <-1, -1, -1>, <1, 1, 1>
    material {
      Mountains_Snow
    }
    scale <30.0, 0.5, 30.0>
    translate  <0.0, 40.0, 10.0>
  }
}


#declare Candle_Stick_Wax5 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 1.0000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.2000, 0.2000, 1.0200> translate -0.0100*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.8000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1000, 0.1000, 1.0200> translate -0.0900*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-1.0020, -1.0020, 0.7980>, <1.0020, 1.0020, 1.0020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.2000, 0.1000  rotate -x*90 translate  0.9000*z bounded_by { box { <-0.3020, -0.3020, 0.7980>, <0.3020, 0.3020, 1.0020> } } }
  torus { 0.2000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.2020, -0.2020, -0.0020>, <0.2020, 0.2020, 0.1020> } } }
  material {
    Wood_8
  }
  scale <-1.1, -1.0, -14.1>
  rotate -180.0*z
  translate  -1.1*z
}
#declare Normal_Candle_Thread5 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1000, 0.1000, 0.5000> translate 0.0000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1000, 0.1000, 0.5100> translate --0.0050*z }
  }
  material {
    Candle_thread_Unburnt
  }
  scale <1.0, 1.0, 2.0>
  translate  -1.5*z
}
#declare Burning_Candle_Thread5 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1000, 0.1000, 0.5000> translate 0.0000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1000, 0.1000, 0.5100> translate --0.0050*z }
  }
  material {
    Red_Flame
  }
  translate  -0.5*z
}
//
// Include file contains 'Yellow_Flame5'
//
#include "old technology.in1"
#declare Yellow_Flame5 = object {
  Yellow_Flame5_Raw
  material {
    Flame_1
  }
  hollow
}
//
// Include file contains 'Candle_Smoke5'
//
#include "old technology.in2"
#declare Candle_Smoke5 = object {
  Candle_Smoke5_Raw
  material {
    Smoke
  }
  hollow
  translate  1.6*z
}
#declare Candle_Stick5 = union { // Candle_Stick5
  object { Candle_Stick_Wax5 }
  object { Normal_Candle_Thread5 }
  object { Burning_Candle_Thread5 }
  object { Yellow_Flame5 }
  object { Candle_Smoke5 }
  object { Light006 }
  hollow
  scale 0.2
  translate  <5.4, 5.6, 8.3>
}


#declare Time_base = prism {
  linear_sweep
  quadratic_spline
  -1.0,0.0
  18  // control points
  <-1.223694, -0.653537>,
  <-1.254777, -0.989384>,
  <-0.85489, -1.024982>,
  <-0.131022, -0.961151>,
  <0.485383, -1.059388>,
  <0.968153, -1.106157>,
  <0.891174, -0.602689>,
  <0.861902, 0.008413>,
  <1.016187, 0.548781>,
  <1.042463, 0.968153>,
  <0.394169, 0.932872>,
  <0.024768, 0.864521>,
  <-0.412652, 0.905305>,
  <-1.265393, 1.07431>,
  <-1.123579, 0.433048>,
  <-1.01222, -0.023176>,
  <-1.223694, -0.653537>,
  <-1.254777, -0.989384>
  rotate -x*90
  material {
    Rusty_Iron
  }
  scale <1.4, 1.4, 0.1>
  translate  <0.4, -3.7, 0.5>
}
#declare Time_Bar = object {
  cylinder { // Time_Bar
    <0,0,1>, <0,0,0>, 1 open
    material {
      Time_Bar_Tex
    }
    scale <0.1, 0.1, 2.0>
    translate  <1.5, -2.7, 0.5>
  }
}
#declare Time_Bar1 = object {
  object { // Time_Bar1 -> Time_Bar
    Time_Bar
    rotate 0.0*z
    translate  -2.0*y
  }
}
#declare Time_Bar2 = object {
  object { // Time_Bar2 -> Time_Bar1
    Time_Bar1
    translate  <-2.6, -0.2, 0.0>
  }
}


#declare Bead20 = object {
  torus { // Bead20
    0.25, 0.25  rotate -x*90
    sturm
    material {
      Shiny_Orb
    }
    scale 0.8
    rotate -90.0*y
    translate  <-3.7, 0.0, 2.3>
  }
}
#declare Bead = object {
  torus { // Bead
    0.25, 0.25  rotate -x*90
    material {
      StemBeadTex
    }
    scale 0.8
    rotate -90.0*y
    translate  <-3.7, 0.0, 4.2>
  }
}
#declare Bar = object {
  cylinder { // Bar
    <0,0,1>, <0,0,0>, 1 open
    material {
      bars
    }
    hollow
    scale <0.1, 0.1, 10.0>
    rotate -90.0*y
    translate  <5.5, 0.0, 4.2>
  }
}




//
// ********  OBJECTS  *******
//

union { // Room
  object { Wall }
  object { // Wall1 -> Wall
    Wall
    rotate -90.0*z
    translate  <-10.8, 10.0, 0.0>
  }
  object { // Wall2 -> Wall
    Wall
    rotate -90.0*x
    translate  <-0.5, -0.6, 21.6>
  }
  translate  <12.3, -6.2, -0.9>
}


merge {  // Table_Top
  cylinder { <0,0,1>,<0,0,0>, 1   scale <9.5000, 9.5000, 1.0000> }
  torus { 9.5000, 0.5000  rotate -x*90 translate  0.5000*z bounded_by { box { <-10.0100, -10.0100, -0.0100>, <10.0100, 10.0100, 1.0100> } } }
  material {
    Skorup5
  }
  translate  <0.7, 5.5, -0.7>
}


#declare Candle_Stick_Wax6 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.9000, 0.9000, 0.5000> }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.2000, 0.2000, 0.5100> translate -0.0050*z }
  }
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <1.0000, 1.0000, 0.3000> translate 0.1000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1000, 0.1000, 0.5100> translate -0.0950*z }
  }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.4000*z bounded_by { box { <-1.0020, -1.0020, 0.2980>, <1.0020, 1.0020, 0.5020> } } }
  torus { 0.9000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-1.0020, -1.0020, -0.0020>, <1.0020, 1.0020, 0.2020> } } }
  torus { 0.2000, 0.1000  rotate -x*90 translate  0.4000*z bounded_by { box { <-0.3020, -0.3020, 0.2980>, <0.3020, 0.3020, 0.5020> } } }
  torus { 0.2000, 0.1000  rotate -x*90 translate  0.1000*z bounded_by { box { <-0.2020, -0.2020, -0.0020>, <0.2020, 0.2020, 0.1020> } } }
  material {
    Wood_8
  }
  scale <-1.1, -1.0, -14.1>
  rotate -180.0*z
  translate  -1.1*z
}
#declare Normal_Candle_Thread6 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1000, 0.1000, 0.5000> translate 0.0000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1000, 0.1000, 0.5100> translate --0.0050*z }
  }
  material {
    Candle_thread_Unburnt
  }
  scale <1.0, 1.0, 2.0>
  translate  -1.5*z
}
#declare Burning_Candle_Thread6 = merge {
  difference {
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1000, 0.1000, 0.5000> translate 0.0000*z }
    cylinder { <0,0,1>,<0,0,0>, 1   scale <0.1000, 0.1000, 0.5100> translate --0.0050*z }
  }
  material {
    Red_Flame
  }
  translate  -0.5*z
}
//
// Include file contains 'Yellow_Flame6'
//
#include "old technology.in3"
#declare Yellow_Flame6 = object {
  Yellow_Flame6_Raw
  material {
    Flame_1
  }
  hollow
}
//
// Include file contains 'Candle_Smoke6'
//
#include "old technology.in4"
#declare Candle_Smoke6 = object {
  Candle_Smoke6_Raw
  material {
    Smoke
  }
  hollow
  translate  1.6*z
}
union { // Chota_Candle_Stick
  object { Candle_Stick_Wax6 }
  object { Normal_Candle_Thread6 }
  object { Burning_Candle_Thread6 }
  object { Yellow_Flame6 }
  object { Candle_Smoke6 }
  object { Light007 }
  hollow
  scale 0.2
  translate  <0.5, 1.6, 1.8>
}


object { // Candle_Stick6 -> Candle_Stick5
  Candle_Stick5
  rotate <-0.0, -0.0, 0.0>
  translate  <-10.0, 0.6, 0.1>
}


object { Candle_Stick5 }


#declare Time_Soil = lathe {
  linear_spline
  6  // control points
  <0.012739, -1.031847>,
  <1.310616, -1.040021>,
  <0.025478, -0.563694>,
  <0.036093, 0.213376>,
  <0.45414, 0.440393>,
  <0.002123, 0.384289>
  rotate <90,0,90>
  material {
    Sand
  }
  scale 0.9
  translate  <0.2, -3.7, 1.5>
}
#declare Time_Glass = lathe {
  linear_spline
  4  // control points
  <1.424628, -1.031847>,
  <0.152866, -0.35138>,
  <0.142251, 0.245223>,
  <1.276008, 0.893843>
  rotate <90,0,90>
  material {
    Truck_Glass
  }
  translate  <0.2, -3.7, 1.5>
}
union { // Time_Clock_Old__type
  object { // Time_base1 -> Time_base
    Time_base
    translate  <0.0, 0.0, 1.9>
  }
  object { Time_base }
  object { Time_Soil }
  object { Time_Glass }
  object { // Time_Bar3 -> Time_Bar2
    Time_Bar2
    translate  2.3*y
  }
  object { Time_Bar1 }
  object { Time_Bar2 }
  object { Time_Bar }
  scale <1.0, 1.0, 2.0>
  rotate -45.0*z
  translate  <6.6, 5.9, -0.8>
}


#declare Bead_3 = union {
  object { // Bead30 -> Bead20
    Bead20
    rotate -0.0*y
    translate  7.8*x
  }
  object { // Bead31 -> Bead20
    Bead20
    rotate -0.0*y
    translate  7.2*x
  }
  object { // Bead32 -> Bead20
    Bead20
    rotate -0.0*y
    translate  6.6*x
  }
  object { // Bead33 -> Bead20
    Bead20
    rotate -0.0*y
    translate  2.4*x
  }
  object { // Bead34 -> Bead20
    Bead20
    rotate -0.0*y
    translate  1.6*x
  }
  object { // Bead35 -> Bead20
    Bead20
    rotate -0.0*y
    translate  0.8*x
  }
  torus { // Bead36
    0.25, 0.25  rotate -x*90
    sturm
    material {
      Shiny_Orb
    }
    scale 0.8
    rotate -90.0*y
    translate  <-3.7, 0.0, 2.3>
  }
  object { // Bead37 -> Bead20
    Bead20
    rotate -0.0*y
    translate  2.8*x
  }
  object { // Bead38 -> Bead20
    Bead20
    rotate -0.0*y
    translate  4.0*x
  }
  object { // Bead39 -> Bead20
    Bead20
    rotate -0.0*y
    translate  3.2*x
  }
  translate  <0.8, 0.0, -1.1>
}
#declare Bead_2 = union {
  object { // Bead29 -> Bead20
    Bead20
    rotate -0.0*y
    translate  7.8*x
  }
  object { // Bead28 -> Bead20
    Bead20
    rotate -0.0*y
    translate  7.2*x
  }
  object { // Bead27 -> Bead20
    Bead20
    rotate -0.0*y
    translate  6.6*x
  }
  object { // Bead23 -> Bead20
    Bead20
    rotate -0.0*y
    translate  2.4*x
  }
  object { // Bead22 -> Bead20
    Bead20
    rotate -0.0*y
    translate  1.6*x
  }
  object { // Bead21 -> Bead20
    Bead20
    rotate -0.0*y
    translate  0.8*x
  }
  object { Bead20 }
  object { // Bead26 -> Bead20
    Bead20
    rotate -0.0*y
    translate  2.8*x
  }
  object { // Bead25 -> Bead20
    Bead20
    rotate -0.0*y
    translate  4.0*x
  }
  object { // Bead24 -> Bead20
    Bead20
    rotate -0.0*y
    translate  3.2*x
  }
}
#declare Beads1 = union {
  object { // Bead10 -> Bead
    Bead
    rotate 0.0*y
    translate  7.6*x
  }
  object { // Bead11 -> Bead
    Bead
    rotate 0.0*y
    translate  6.5*x
  }
  object { // Bead12 -> Bead
    Bead
    rotate 0.0*y
    translate  7.0*x
  }
  object { // Bead13 -> Bead
    Bead
    rotate 0.0*y
    translate  2.0*x
  }
  object { // Bead14 -> Bead
    Bead
    rotate 0.0*y
    translate  5.9*x
  }
  object { // Bead15 -> Bead
    Bead
    rotate 0.0*y
    translate  2.6*x
  }
  object { // Bead16 -> Bead
    Bead
    rotate 0.0*y
    translate  1.5*x
  }
  object { // Bead17 -> Bead
    Bead
    rotate 0.0*y
    translate  1.0*x
  }
  object { // Bead18 -> Bead
    Bead
    rotate 0.0*y
    translate  0.5*x
  }
  torus { // Bead19
    0.25, 0.25  rotate -x*90
    sturm
    material {
      StemBeadTex
    }
    scale 0.8
    rotate -90.0*y
    translate  <-3.7, 0.0, 4.2>
  }
  translate  -1.0*z
}
#declare Beads = union {
  object { // Bead9 -> Bead
    Bead
    rotate 0.0*y
    translate  4.3*x
  }
  object { // Bead8 -> Bead
    Bead
    rotate 0.0*y
    translate  3.8*x
  }
  object { // Bead7 -> Bead
    Bead
    rotate 0.0*y
    translate  7.0*x
  }
  object { // Bead3 -> Bead
    Bead
    rotate 0.0*y
    translate  2.0*x
  }
  object { // Bead6 -> Bead
    Bead
    rotate 0.0*y
    translate  3.2*x
  }
  object { // Bead5 -> Bead
    Bead
    rotate 0.0*y
    translate  2.6*x
  }
  object { // Bead4 -> Bead
    Bead
    rotate 0.0*y
    translate  1.5*x
  }
  object { // Bead2 -> Bead
    Bead
    rotate 0.0*y
    translate  1.0*x
  }
  object { // Bead1 -> Bead
    Bead
    rotate 0.0*y
    translate  0.5*x
  }
  object { Bead }
}
#declare Stand_2 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.002123, 0.373673>,
  <-0.968153, 0.861996>,
  <-1.042463, -0.55414>,
  <0.055202, -0.214437>,
  <-0.009366, 0.036338>,
  <0.140212, 0.210531>,
  <0.002123, 0.373673>,
  <-0.968153, 0.861996>,
  <-1.042463, -0.55414>
  rotate -x*90
  material {
    Stand
  }
  scale <1.0, 1.0, 5.0>
  rotate <180.0, 0.0, 180.0>
  translate  <5.4, 0.0, 5.3>
}
#declare Stand_1 = prism {
  linear_sweep
  cubic_spline
  -1.0,0.0
  9  // control points
  <0.002123, 0.373673>,
  <-0.968153, 0.861996>,
  <-1.042463, -0.55414>,
  <0.055202, -0.214437>,
  <-0.009366, 0.036338>,
  <0.140212, 0.210531>,
  <0.002123, 0.373673>,
  <-0.968153, 0.861996>,
  <-1.042463, -0.55414>
  rotate -x*90
  material {
    Stand
  }
  scale <1.0, 1.0, 5.0>
  translate  <-4.3, 0.0, 0.3>
}
// Include contains 'abacus_top'
#include "old technology.in5"

#declare abacus_top = object {
  abacus_top_Raw
  material {
    Wood_Tex
  }
  scale <3.0, 1.0, 0.2>
  translate  5.0*z
}
// Include contains 'abacus_base'
#include "old technology.in6"

#declare abacus_base = object {
  abacus_base_Raw
  material {
    Wood_Tex
  }
  scale <3.0, 1.0, 0.5>
}
#declare Abacus_Frame = union {
  object { Stand_2 }
  object { Stand_1 }
  object { abacus_top }
  object { abacus_base }
  object { Bar }
  object { // Bar1 -> Bar
    Bar
    rotate <0.0, 0.0, 0.0>
    translate  -1.0*z
  }
  object { // Bar2 -> Bar
    Bar
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 0.1, -1.9>
  }
  object { // Bar3 -> Bar
    Bar
    rotate <0.0, 0.0, 0.0>
    translate  <0.0, 0.1, -3.0>
  }
}
union { // Abacus
  object { Bead_3 }
  object { Bead_2 }
  object { Beads1 }
  object { Beads }
  object { Abacus_Frame }
  translate  <0.3, 5.7, 0.0>
}


